<?php
namespace App\Http\Controllers;
use App\Models\Client; use App\Services\PdfService; use Illuminate\Support\Str;
class PdfExportController extends Controller {
  public function tracking(Client $client, PdfService $pdf){
    $data=['client'=>$client,'entries'=>$client->trackingEntries()->orderBy('date_signed_out')->get()];
    return $pdf->render('pdf.tracking-sheet',$data)->download('tracking-'.Str::slug($client->client_name).'.pdf');
  }
  public function followup(Client $client, PdfService $pdf){
    $data=['client'=>$client,'comments'=>$client->comments()->with('author')->orderByDesc('comment_date')->get()];
    return $pdf->render('pdf.case-follow-up',$data)->download('followup-'.Str::slug($client->client_name).'.pdf');
  }
  public function full(Client $client, PdfService $pdf){
    $data=['client'=>$client,'entries'=>$client->trackingEntries,'comments'=>$client->comments()->with('author')->get()];
    return $pdf->render('pdf.client-full',$data)->download('client-'.Str::slug($client->client_name).'.pdf');
  }
}