#!/usr/bin/env bash
set -euo pipefail
APP_DIR="${1:-client-tracker}"
PHP_BIN="${PHP_BIN:-php}"
COMPOSER_BIN="${COMPOSER_BIN:-composer}"
${COMPOSER_BIN} create-project laravel/laravel "${APP_DIR}"
cd "${APP_DIR}"
${COMPOSER_BIN} require laravel/fortify:"^1.19" barryvdh/laravel-dompdf:"^2.0"
${PHP_BIN} artisan vendor:publish --provider="Laravel\\Fortify\\FortifyServiceProvider" --force
rsync -a "$(cd "$(dirname "$0")" && pwd)/files/" "./"
if ! grep -q "App\\Providers\\FortifyServiceProvider::class" config/app.php; then
  sed -i.bak 's/RouteServiceProvider::class,/RouteServiceProvider::class,\n        App\\Providers\\FortifyServiceProvider::class,/' config/app.php
fi
${PHP_BIN} artisan key:generate || true
${PHP_BIN} artisan migrate --force
${PHP_BIN} artisan db:seed --class=StarterSeeder --force || true
${PHP_BIN} artisan storage:link || true
echo "Admin: admin@example.com / password (change immediately)"
