<?php

namespace App\Http\Controllers;

use App\Models\Client;
use Illuminate\Http\Request;

class ClientController extends Controller
{
    public function index(Request $request)
    {
        $q = $request->input('q');
        $clients = Client::query()
            ->when($q, function($query) use ($q){
                $query->where('client_name','like',"%$q%")
                      ->orWhere('alien_number','like',"%$q%")
                      ->orWhere('phone_number','like',"%$q%");
            })
            ->orderBy('client_name')
            ->paginate(20)
            ->withQueryString();

        return view('clients.index', compact('clients','q'));
    }

    public function create(){ return view('clients.create'); }

    public function store(Request $request)
    {
        $data = $request->validate([
            'client_name'=>'required|max:255',
            'alien_number'=>'nullable|max:64',
            'phone_number'=>'nullable|max:32',
        ]);
        $client = Client::create($data);
        return redirect()->route('clients.show', $client)->with('ok','Client created.');
    }

    public function show(Client $client)
    {
        $client->load(['trackingEntries','comments.author']);
        return view('clients.show', compact('client'));
    }

    public function update(Request $request, Client $client)
    {
        $data = $request->validate([
            'client_name'=>'required|max:255',
            'alien_number'=>'nullable|max:64',
            'phone_number'=>'nullable|max:32',
        ]);
        $client->update($data);
        return back()->with('ok','Client updated.');
    }

    public function destroy(Client $client)
    {
        $client->delete();
        return redirect()->route('clients.index')->with('ok','Client deleted (soft).');
    }
}
