<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\Comment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Services\AuditLogger;
use Illuminate\Support\Carbon;

class CommentController extends Controller
{
    public function store(Request $request, Client $client)
    {
        $data = $request->validate([
            'comment_text'=>'required|string',
        ]);
        $comment = Comment::create([
            'client_id' => $client->id,
            'comment_text' => $data['comment_text'],
            'comment_date' => Carbon::now(),
            'comment_author_id' => Auth::id(),
            'locked' => true,
        ]);
        return back()->with('ok','Comment added.');
    }

    public function update(Request $request, Comment $comment, AuditLogger $audit)
    {
        $before = $comment->toArray();
        $data = $request->validate([ 'comment_text'=>'required|string' ]);
        $comment->update($data);
        $audit->log('EDIT_COMMENT', $comment, $before, $comment->toArray(), $request->input('reason'));
        return back()->with('ok','Comment updated by ADMIN.');
    }

    public function destroy(Request $request, Comment $comment, AuditLogger $audit)
    {
        $before = $comment->toArray();
        $comment->delete();
        $audit->log('DELETE_COMMENT', $comment, $before, null, $request->input('reason'));
        return back()->with('ok','Comment deleted by ADMIN.');
    }
}
