<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TrackingEntry extends Model
{
    protected $fillable = [
        'client_id','date_signed_out','out_to_role','date_into_central_filing','staff_name'
    ];

    protected $casts = [
        'date_signed_out' => 'date',
        'date_into_central_filing' => 'date',
    ];

    public function client() { return $this->belongsTo(Client::class); }
}
