<?php

namespace App\Services;

use App\Models\AuditLog;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;

class AuditLogger
{
    public function log(string $action, Model $target, array $before = null, array $after = null, ?string $reason = null): void
    {
        AuditLog::create([
            'actor_user_id' => optional(Auth::user())->id,
            'action' => $action,
            'target_type' => class_basename($target),
            'target_id' => $target->getKey(),
            'before_json' => $before,
            'after_json' => $after,
            'reason' => $reason,
            'created_at' => Carbon::now(),
        ]);
    }
}
