<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('tracking_entries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->constrained()->cascadeOnDelete();
            $table->date('date_signed_out')->nullable();
            $table->enum('out_to_role',['ATTORNEY','PARALEGAL','OTHER'])->nullable();
            $table->string('staff_name')->nullable();
            $table->date('date_into_central_filing')->nullable();
            $table->timestamps();
            $table->index(['client_id','date_signed_out','date_into_central_filing']);
        });
    }
    public function down(): void {
        Schema::dropIfExists('tracking_entries');
    }
};
