<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('comments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->constrained()->cascadeOnDelete();
            $table->text('comment_text');
            $table->dateTime('comment_date');
            $table->foreignId('comment_author_id')->constrained('users');
            $table->boolean('locked')->default(true);
            $table->timestamps();
            $table->fullText('comment_text');
        });
    }
    public function down(): void {
        Schema::dropIfExists('comments');
    }
};
