<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class StarterSeeder extends Seeder
{
    public function run(): void
    {
        if(!User::where('email','admin@example.com')->exists()){
            User::create([
                'name'=>'Admin',
                'email'=>'admin@example.com',
                'password'=>Hash::make('password'),
                'role'=>'ADMIN',
            ]);
        }
        if(!User::where('email','staff@example.com')->exists()){
            User::create([
                'name'=>'Staff',
                'email'=>'staff@example.com',
                'password'=>Hash::make('password'),
                'role'=>'STAFF',
            ]);
        }
    }
}
