@extends('layouts.app')
@section('content')
<div class="bg-white p-4 rounded shadow">
  <h1 class="text-lg font-semibold mb-3">Audit Log</h1>
  <form method="get" class="mb-3">
    <input class="border p-2 rounded" name="q" value="{{ $q }}" placeholder="Filter by action, target, reason...">
    <button class="px-3 py-2 bg-gray-800 text-white rounded">Search</button>
  </form>
  <table class="w-full text-sm">
    <thead><tr class="border-b">
      <th class="p-2 text-left">When</th>
      <th class="p-2 text-left">Who</th>
      <th class="p-2 text-left">Action</th>
      <th class="p-2 text-left">Target</th>
      <th class="p-2 text-left">Detail</th>
    </tr></thead>
    <tbody>
    @foreach($logs as $log)
      <tr class="border-b">
        <td class="p-2">{{ $log->created_at }}</td>
        <td class="p-2">{{ optional($log->actor)->email }}</td>
        <td class="p-2">{{ $log->action }}</td>
        <td class="p-2">{{ $log->target_type }}#{{ $log->target_id }}</td>
        <td class="p-2"><a class="text-blue-700" href="{{ route('audit.show',$log) }}">View</a></td>
      </tr>
    @endforeach
    </tbody>
  </table>
  <div class="mt-3">{{ $logs->links() }}</div>
</div>
@endsection
