#!/usr/bin/env bash
set -euo pipefail

APP_DIR="${1:-client-tracker}"
APP_NAME="Client Tracker"
PHP_BIN="${PHP_BIN:-php}"
COMPOSER_BIN="${COMPOSER_BIN:-composer}"

echo "==> Creating Laravel app in ${APP_DIR}"
${COMPOSER_BIN} create-project laravel/laravel "${APP_DIR}"

cd "${APP_DIR}"

echo "==> Installing dependencies (Fortify + Dompdf)"
${COMPOSER_BIN} require laravel/fortify:"^1.19" barryvdh/laravel-dompdf:"^2.0"

echo "==> Publishing Fortify config & migrations"
${PHP_BIN} artisan vendor:publish --provider="Laravel\\Fortify\\FortifyServiceProvider"

echo "==> Copying Client Tracker package files"
PKG_DIR="$(cd "$(dirname "$0")" && pwd)/files"
rsync -a "${PKG_DIR}/" "./"

echo "==> Updating app providers to register FortifyServiceProvider"
if ! grep -q "App\\\Providers\\\FortifyServiceProvider::class" config/app.php; then
  sed -i.bak 's/        App\\\Providers\\\RouteServiceProvider::class,/        App\\\Providers\\\RouteServiceProvider::class,\n        App\\\Providers\\\FortifyServiceProvider::class,/' config/app.php
fi

echo "==> Generating APP_KEY if needed"
${PHP_BIN} artisan key:generate || true

echo "==> Running migrations"
${PHP_BIN} artisan migrate --force

echo "==> Seeding admin/staff users"
${PHP_BIN} artisan db:seed --class=StarterSeeder --force || true

echo "==> Creating storage symlink"
${PHP_BIN} artisan storage:link || true

echo "==> Done. Next steps:"
echo "1) Create a MySQL database & user in cPanel and set DB_* in .env"
echo "2) Ensure Document Root points to public/"
echo "3) Login with admin@example.com / password (change immediately)"
