# Client Tracker Starter (Laravel Add-on)

This package installs a Laravel-based client tracking app with:
- Clients & Tracking entries (from Tracking Sheet)
- Append-only Comments (Case Follow Up) with auto date + author
- Admin-only edit/delete with full audit logs
- Global search and a dedicated searchable Audit Log
- PDF export for Tracking Sheet, Case Follow Up, and Full Client file
- Fortify authentication (no Node required), Dompdf for PDF
- cPanel-friendly deployment

## Quick Install (cPanel Terminal)
```bash
# Upload this zip to your home directory and extract
unzip client-tracker-starter.zip
cd client-tracker-starter

# Create the app in 'client-tracker' folder (or pass a different folder name)
bash installer.sh client-tracker
```

## Configure .env
In `client-tracker/.env`, set your DB connection (created in cPanel > MySQL Databases):
```
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=your_db_name
DB_USERNAME=your_db_user
DB_PASSWORD=your_db_pass
APP_URL=https://your-domain.example.com
```

## Webroot
Point your domain/subdomain Document Root to `client-tracker/public` in cPanel.

## Default Logins
- Admin: `admin@example.com` / `password`
- Staff: `staff@example.com` / `password`
**Change these immediately.**

## PDF Notes
- Dompdf is configured with Letter portrait and print-safe tables.
- Exports: Client page dropdown → Tracking, Follow Up, Full packet. Batch export route available.

## Uninstall
Remove the app directory and associated DB.
