<?php

namespace App\Http\Controllers;

use App\Models\AuditLog;
use Illuminate\Http\Request;

class AuditController extends Controller
{
    public function index(Request $request)
    {
        $q = $request->input('q');
        $logs = AuditLog::query()
            ->when($q, function($query) use ($q){
                $query->where('action','like',"%$q%")
                    ->orWhere('target_type','like',"%$q%")
                    ->orWhere('reason','like',"%$q%");
            })
            ->orderByDesc('created_at')
            ->paginate(30)->withQueryString();
        return view('audit.index', compact('logs','q'));
    }

    public function show(AuditLog $log)
    {
        return view('audit.show', compact('log'));
    }
}
