<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Client;
use App\Models\Comment;
use App\Models\TrackingEntry;

class SearchController extends Controller
{
    public function index(Request $request)
    {
        $q = $request->input('q','');
        $clients = Client::query()
            ->where('client_name','like',"%$q%")
            ->orWhere('alien_number','like',"%$q%")
            ->orWhere('phone_number','like',"%$q%")
            ->limit(25)->get();

        $comments = Comment::query()
            ->where('comment_text','like',"%$q%")
            ->limit(25)->with('client','author')->get();

        $entries = TrackingEntry::query()
            ->where('staff_name','like',"%$q%")
            ->limit(25)->with('client')->get();

        return view('search.index', compact('q','clients','comments','entries'));
    }
}
