<?php

namespace App\Http\Controllers;

use App\Models\Client;
use App\Models\TrackingEntry;
use Illuminate\Http\Request;
use App\Services\AuditLogger;

class TrackingEntryController extends Controller
{
    public function store(Request $request, Client $client)
    {
        $data = $request->validate([
            'date_signed_out'=>'nullable|date',
            'out_to_role'=>'nullable|in:ATTORNEY,PARALEGAL,OTHER',
            'staff_name'=>'nullable|max:255',
            'date_into_central_filing'=>'nullable|date',
        ]);
        $data['client_id'] = $client->id;
        TrackingEntry::create($data);
        return back()->with('ok','Tracking entry added.');
    }

    public function update(Request $request, TrackingEntry $entry, AuditLogger $audit)
    {
        $before = $entry->toArray();
        $data = $request->validate([
            'date_signed_out'=>'nullable|date',
            'out_to_role'=>'nullable|in:ATTORNEY,PARALEGAL,OTHER',
            'staff_name'=>'nullable|max:255',
            'date_into_central_filing'=>'nullable|date',
        ]);
        $entry->update($data);
        $audit->log('EDIT_TRACKING', $entry, $before, $entry->toArray(), $request->input('reason'));
        return back()->with('ok','Tracking updated.');
    }

    public function destroy(Request $request, TrackingEntry $entry, AuditLogger $audit)
    {
        $before = $entry->toArray();
        $entry->delete();
        $audit->log('DELETE_TRACKING', $entry, $before, null, $request->input('reason'));
        return back()->with('ok','Tracking deleted.');
    }
}
