<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AuditLog extends Model
{
    public $timestamps = false;
    protected $fillable = [
        'actor_user_id','action','target_type','target_id','before_json','after_json','reason','created_at'
    ];
    protected $casts = [
        'before_json' => 'array',
        'after_json' => 'array',
        'created_at' => 'datetime',
    ];
    public function actor(){ return $this->belongsTo(User::class, 'actor_user_id'); }
}
