<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Comment extends Model
{
    protected $fillable = ['client_id','comment_text','comment_date','comment_author_id','locked'];

    protected $casts = [
        'comment_date' => 'datetime',
        'locked' => 'boolean',
    ];

    public function client() { return $this->belongsTo(Client::class); }
    public function author() { return $this->belongsTo(User::class, 'comment_author_id'); }
}
