<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use App\Models\User;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        // Register policies here if needed
    ];

    public function boot(): void
    {
        $this->registerPolicies();

        Gate::define('admin', function (?User $user) {
            return $user && $user->role === 'ADMIN';
        });
    }
}
