@extends('layouts.app')
@section('content')
<div class="bg-white p-4 rounded shadow">
  <div class="flex justify-between mb-3">
    <form method="get">
      <input name="q" value="{{ $q }}" placeholder="Search clients..." class="border rounded p-2">
      <button class="px-3 py-2 bg-gray-800 text-white rounded">Search</button>
    </form>
    <a class="px-3 py-2 bg-blue-600 text-white rounded" href="{{ route('clients.create') }}">Add Client</a>
  </div>
  <table class="w-full text-sm">
    <thead><tr class="border-b">
      <th class="text-left p-2">Name</th>
      <th class="text-left p-2">Alien #</th>
      <th class="text-left p-2">Phone</th>
      <th class="text-left p-2">Actions</th>
    </tr></thead>
    <tbody>
    @foreach($clients as $c)
      <tr class="border-b">
        <td class="p-2">{{ $c->client_name }}</td>
        <td class="p-2">{{ $c->alien_number }}</td>
        <td class="p-2">{{ $c->phone_number }}</td>
        <td class="p-2">
          <a class="text-blue-700" href="{{ route('clients.show',$c) }}">Open</a>
        </td>
      </tr>
    @endforeach
    </tbody>
  </table>
  <div class="mt-3">{{ $clients->links() }}</div>
</div>
@endsection
