@extends('layouts.app')
@section('content')
<div class="grid md:grid-cols-2 gap-4">
  <div class="bg-white p-4 rounded shadow">
    <form method="post" action="{{ route('clients.update',$client) }}">
      @csrf @method('PUT')
      <h2 class="font-semibold mb-3">Client</h2>
      <div class="mb-2">
        <label class="block text-sm">Name</label>
        <input name="client_name" class="w-full border p-2 rounded" value="{{ $client->client_name }}">
      </div>
      <div class="mb-2">
        <label class="block text-sm">Alien #</label>
        <input name="alien_number" class="w-full border p-2 rounded" value="{{ $client->alien_number }}">
      </div>
      <div class="mb-2">
        <label class="block text-sm">Phone</label>
        <input name="phone_number" class="w-full border p-2 rounded" value="{{ $client->phone_number }}">
      </div>
      <div class="flex gap-2 mt-2">
        <button class="bg-blue-600 text-white px-3 py-2 rounded">Update</button>
        @can('admin')
        <form method="post" action="{{ route('clients.destroy',$client) }}">@csrf @method('DELETE')
          <button class="bg-red-600 text-white px-3 py-2 rounded">Delete</button>
        </form>
        @endcan
      </div>
      <div class="mt-3">
        <div class="inline-block relative">
          <details>
            <summary class="cursor-pointer px-3 py-2 bg-gray-800 text-white rounded inline-block">Export</summary>
            <div class="absolute bg-white border rounded mt-1 p-2">
              <a class="block px-3 py-1 hover:bg-gray-100" href="{{ route('export.tracking',$client) }}">Tracking Sheet (PDF)</a>
              <a class="block px-3 py-1 hover:bg-gray-100" href="{{ route('export.followup',$client) }}">Case Follow Up (PDF)</a>
              <a class="block px-3 py-1 hover:bg-gray-100" href="{{ route('export.full',$client) }}">Full Client File (PDF)</a>
            </div>
          </details>
        </div>
      </div>
    </form>
  </div>

  <div class="bg-white p-4 rounded shadow">
    <h2 class="font-semibold mb-3">Tracking</h2>
    <form method="post" action="{{ route('tracking.store',$client) }}" class="grid grid-cols-2 gap-2">
      @csrf
      <div>
        <label class="block text-sm">Date Signed Out</label>
        <input type="date" name="date_signed_out" class="w-full border p-2 rounded">
      </div>
      <div>
        <label class="block text-sm">To (Role)</label>
        <select name="out_to_role" class="w-full border p-2 rounded">
          <option value="">—</option>
          <option>ATTORNEY</option><option>PARALEGAL</option><option>OTHER</option>
        </select>
      </div>
      <div>
        <label class="block text-sm">Attorney/Paralegal Name</label>
        <input name="staff_name" class="w-full border p-2 rounded">
      </div>
      <div>
        <label class="block text-sm">Date Into Central Filing</label>
        <input type="date" name="date_into_central_filing" class="w-full border p-2 rounded">
      </div>
      <div class="col-span-2">
        <button class="bg-blue-600 text-white px-4 py-2 rounded">Add Tracking Entry</button>
      </div>
    </form>
    <table class="w-full text-sm mt-3">
      <thead><tr class="border-b">
        <th class="p-2 text-left">Date Out</th><th class="p-2 text-left">To</th><th class="p-2 text-left">Name</th><th class="p-2 text-left">Date Into CF</th>
      </tr></thead>
      <tbody>
        @foreach($client->trackingEntries as $t)
          <tr class="border-b">
            <td class="p-2">{{ $t->date_signed_out }}</td>
            <td class="p-2">{{ $t->out_to_role }}</td>
            <td class="p-2">{{ $t->staff_name }}</td>
            <td class="p-2">{{ $t->date_into_central_filing }}</td>
          </tr>
        @endforeach
      </tbody>
    </table>
  </div>

  <div class="bg-white p-4 rounded shadow md:col-span-2">
    <h2 class="font-semibold mb-2">Case Follow Up / Comments</h2>
    <form method="post" action="{{ route('comments.store',$client) }}">
      @csrf
      <label class="block text-sm">New Comment</label>
      <textarea name="comment_text" class="w-full border p-2 rounded" rows="3" placeholder="Type comment... (auto date & author)"></textarea>
      <button class="mt-2 bg-blue-600 text-white px-4 py-2 rounded">Add Comment</button>
    </form>
    <table class="w-full text-sm mt-3">
      <thead><tr class="border-b bg-gray-100">
        <th class="p-2 text-left w-1/5">Date</th>
        <th class="p-2 text-left w-3/5">Comments</th>
        <th class="p-2 text-left w-1/5">Lawyer</th>
      </tr></thead>
      <tbody>
      @foreach($client->comments as $c)
        <tr class="border-b align-top">
          <td class="p-2">{{ $c->comment_date->setTimezone('America/Chicago')->format('M d, Y h:i a') }}</td>
          <td class="p-2 whitespace-pre-line">{{ $c->comment_text }}</td>
          <td class="p-2">{{ optional($c->author)->name }}</td>
        </tr>
      @endforeach
      </tbody>
    </table>
  </div>
</div>
@endsection
