<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>{{ $title ?? 'Client Tracker' }}</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="bg-gray-50">
<nav class="bg-white shadow">
  <div class="max-w-6xl mx-auto px-4 py-3 flex justify-between">
    <a href="{{ route('clients.index') }}" class="font-semibold">Client Tracker</a>
    <div class="space-x-4">
      <a href="{{ route('clients.index') }}">Clients</a>
      <a href="{{ route('search.index') }}">Search</a>
      @can('admin') <a href="{{ route('audit.index') }}">Audit Log</a> @endcan
      <form class="inline" method="POST" action="/logout">@csrf<button class="text-red-600">Logout</button></form>
    </div>
  </div>
</nav>
<main class="max-w-6xl mx-auto p-4">
  @if(session('ok'))
    <div class="bg-green-100 text-green-800 px-3 py-2 rounded mb-3">{{ session('ok') }}</div>
  @endif
  @yield('content')
</main>
</body>
</html>
