@extends('layouts.app')
@section('content')
<div class="bg-white p-4 rounded shadow">
  <h1 class="text-lg font-semibold mb-3">Global Search</h1>
  <form method="get" class="mb-3">
    <input class="border p-2 rounded" name="q" value="{{ $q }}" placeholder="Search clients, comments, tracking...">
    <button class="px-3 py-2 bg-gray-800 text-white rounded">Go</button>
  </form>
  <div class="grid md:grid-cols-3 gap-4">
    <div>
      <h2 class="font-semibold mb-2">Clients</h2>
      <ul class="list-disc ml-5 text-sm">
      @foreach($clients as $c)
        <li><a class="text-blue-700" href="{{ route('clients.show',$c) }}">{{ $c->client_name }}</a></li>
      @endforeach
      </ul>
    </div>
    <div>
      <h2 class="font-semibold mb-2">Comments</h2>
      <ul class="list-disc ml-5 text-sm">
      @foreach($comments as $c)
        <li><a class="text-blue-700" href="{{ route('clients.show',$c->client) }}">{{ Str::limit($c->comment_text, 60) }}</a></li>
      @endforeach
      </ul>
    </div>
    <div>
      <h2 class="font-semibold mb-2">Tracking</h2>
      <ul class="list-disc ml-5 text-sm">
      @foreach($entries as $e)
        <li><a class="text-blue-700" href="{{ route('clients.show',$e->client) }}">{{ $e->staff_name }} ({{ $e->out_to_role }})</a></li>
      @endforeach
      </ul>
    </div>
  </div>
</div>
@endsection
