<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\TrackingEntryController;
use App\Http\Controllers\CommentController;
use App\Http\Controllers\AuditController;
use App\Http\Controllers\PdfExportController;
use App\Http\Controllers\SearchController;

Route::get('/', function () { return redirect()->route('clients.index'); })->name('home');

// Auth (Fortify handles /login, /register, /logout)
Route::middleware(['auth'])->group(function () {
    Route::get('/clients', [ClientController::class, 'index'])->name('clients.index');
    Route::get('/clients/create', [ClientController::class, 'create'])->name('clients.create');
    Route::post('/clients', [ClientController::class, 'store'])->name('clients.store');
    Route::get('/clients/{client}', [ClientController::class, 'show'])->name('clients.show');
    Route::put('/clients/{client}', [ClientController::class, 'update'])->name('clients.update');
    Route::delete('/clients/{client}', [ClientController::class, 'destroy'])->middleware('can:admin')->name('clients.destroy');

    Route::post('/clients/{client}/tracking', [TrackingEntryController::class, 'store'])->name('tracking.store');
    Route::patch('/tracking/{entry}', [TrackingEntryController::class, 'update'])->middleware('can:admin')->name('tracking.update');
    Route::delete('/tracking/{entry}', [TrackingEntryController::class, 'destroy'])->middleware('can:admin')->name('tracking.destroy');

    Route::post('/clients/{client}/comments', [CommentController::class, 'store'])->name('comments.store');
    Route::patch('/comments/{comment}', [CommentController::class, 'update'])->middleware('can:admin')->name('comments.update');
    Route::delete('/comments/{comment}', [CommentController::class, 'destroy'])->middleware('can:admin')->name('comments.destroy');

    Route::get('/audit', [AuditController::class, 'index'])->middleware('can:admin')->name('audit.index');
    Route::get('/audit/{log}', [AuditController::class, 'show'])->middleware('can:admin')->name('audit.show');

    Route::get('/search', [SearchController::class, 'index'])->name('search.index');

    // PDF Exports
    Route::get('/clients/{client}/export/tracking.pdf', [PdfExportController::class, 'tracking'])->name('export.tracking');
    Route::get('/clients/{client}/export/followup.pdf', [PdfExportController::class, 'followup'])->name('export.followup');
    Route::get('/clients/{client}/export/full.pdf', [PdfExportController::class, 'full'])->name('export.full');
    Route::post('/clients/export.zip', [PdfExportController::class, 'batch'])->middleware('can:admin')->name('export.batch');
});
